package agent

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/skotty/skotty/internal/config"
	"a.yandex-team.ru/security/skotty/skotty/internal/confirm"
	"a.yandex-team.ru/security/skotty/skotty/internal/ui"
)

type Option interface {
	isOption()
}

type loggerOption struct {
	Option
	logger log.Logger
}

func WithLogger(l log.Logger) Option {
	return loggerOption{
		logger: l,
	}
}

type socketsOption struct {
	Option
	sockets []config.Socket
}

func WithSockets(sockets ...config.Socket) Option {
	return socketsOption{
		sockets: sockets,
	}
}

type notifierOption struct {
	Option
	notifier ui.Notifier
}

func WithNotifier(n ui.Notifier) Option {
	return notifierOption{
		notifier: n,
	}
}

type confirmatorOption struct {
	Option
	confirmator confirm.Confirmator
}

func WithConfirmator(c confirm.Confirmator) Option {
	return confirmatorOption{
		confirmator: c,
	}
}
