#!/bin/sh

set -xe

input_filepath="../../../assets/logo.png" 
output_iconset_name="skotty.iconset"
rm -Rf $output_iconset_name
mkdir $output_iconset_name

# Normal screen icons
for SIZE in 16 32 64 128 256 512; do
sips -z $SIZE $SIZE $input_filepath --out "${output_iconset_name}/icon_${SIZE}x${SIZE}.png" ;
done

# Retina display icons
for SIZE in 32 64 256 512; do
sips -z $SIZE $SIZE $input_filepath --out "${output_iconset_name}/icon_$(expr $SIZE / 2)x$(expr $SIZE / 2)x2.png" ;
done


#sips -z 16 16     $input_filepath --out "${output_iconset_name}/icon_16x16.png"
#sips -z 32 32     $input_filepath --out "${output_iconset_name}/icon_16x16@2x.png"
#sips -z 32 32     $input_filepath --out "${output_iconset_name}/icon_32x32.png"
#sips -z 64 64     $input_filepath --out "${output_iconset_name}/icon_32x32@2x.png"
#s#ips -z 128 128   $input_filepath --out "${output_iconset_name}/icon_128x128.png"
#sips -z 256 256   $input_filepath --out "${output_iconset_name}/icon_128x128@2x.png"
#sips -z 256 256   $input_filepath --out "${output_iconset_name}/icon_256x256.png"
#sips -z 512 512   $input_filepath --out "${output_iconset_name}/icon_256x256@2x.png"
#sips -z 512 512   $input_filepath --out "${output_iconset_name}/icon_512x512.png"
#sips -z 1024 1024   $input_filepath --out "${output_iconset_name}/icon_512x512@2x.png"
#sips -z 1024 1024   $input_filepath --out "${output_iconset_name}/icon_1024x1024.png"
#sips -z 2048 2048   $input_filepath --out "${output_iconset_name}/icon_1024x1024@2x.png"

iconutil -c icns -o darwin/Resources/skotty.icns $output_iconset_name

#rm -Rf $output_iconset_name