package assets

import (
	_ "embed"
	"fmt"
	"io/fs"
	"os"
	"path/filepath"
)

//go:embed darwin/Info.plist
var infoPlist string

func InfoPlist() string {
	return infoPlist
}

func exportFS(source fs.FS, target string) error {
	return fs.WalkDir(source, ".", func(path string, d fs.DirEntry, err error) error {
		if err != nil {
			return err
		}

		if path == "." {
			return nil
		}

		if d.IsDir() {
			return os.MkdirAll(filepath.Join(target, path), 0o755)
		}

		data, err := fs.ReadFile(source, path)
		if err != nil {
			return fmt.Errorf("failed to read embed file %q: %w", path, err)
		}

		err = os.WriteFile(filepath.Join(target, path), data, 0o644)
		if err != nil {
			return fmt.Errorf("failed to write embed file %q: %w", path, err)
		}

		return nil
	})
}
