package assets

import (
	"embed"
	"fmt"
	"io/fs"
	"os"
	"path/filepath"

	"a.yandex-team.ru/security/libs/go/ioatomic"
)

//go:embed darwin/*
var darwinFS embed.FS

func UnBundle(sourceExe, dst string) error {
	if _, err := os.Stat(filepath.Join(dst, "Skotty.app")); err == nil {
		// already done by unpacker
		return nil
	}

	contentsPath := filepath.Join(dst, "Skotty.app", "Contents")
	for _, d := range []string{"MacOS", "Resources"} {
		if err := os.MkdirAll(filepath.Join(contentsPath, d), 0o755); err != nil {
			return fmt.Errorf("failed to create macOS bundle dirs: %w", err)
		}
	}

	targetExe := filepath.Join(contentsPath, "MacOS", "skotty")
	if err := ioatomic.CopyFile(sourceExe, targetExe); err != nil {
		return fmt.Errorf("failed to copy macOS binary: %w", err)
	}

	sourceFS, err := fs.Sub(darwinFS, "darwin")
	if err != nil {
		return err
	}

	if err := exportFS(sourceFS, contentsPath); err != nil {
		return err
	}

	if err := os.Rename(sourceExe, sourceExe+".old"); err != nil {
		return err
	}

	return os.Symlink(targetExe, sourceExe)
}
