//go:build !darwin
// +build !darwin

package assets

import (
	"embed"
	"io/fs"
	"os"
	"path/filepath"
)

//go:embed icons/*
var iconsFS embed.FS

func UnBundle(_, dst string) error {
	dstDir := filepath.Join(dst, "usr", "share", "icons")
	err := os.MkdirAll(dstDir, 0o755)
	if err != nil {
		return err
	}

	sourceFS, err := fs.Sub(iconsFS, "icons")
	if err != nil {
		return err
	}

	return exportFS(sourceFS, dstDir)
}
