package commands

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/skotty/skotty/internal/diag"
)

var dumpCmd = &cobra.Command{
	Use:          "dump",
	SilenceUsage: true,
	Short:        "dumps various info",
}

var debugCmd = &cobra.Command{
	Use:          "debug",
	SilenceUsage: true,
	Short:        "dumps debug info",
	RunE: func(_ *cobra.Command, _ []string) error {
		f, err := os.CreateTemp("", "skotty_diag.*.txt")
		if err != nil {
			return fmt.Errorf("unable to create temporary file: %w", err)
		}

		diag.Collect(f)
		if err := f.Close(); err != nil {
			return err
		}

		fmt.Printf("debug info saved into: %s\n", f.Name())
		return nil
	},
}

func init() {
	dumpCmd.AddCommand(debugCmd)
}
