package commands

import (
	"bytes"
	"errors"
	"fmt"
	"io"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/skotty/skotty/internal/passutil"
)

var passtoolCmd = &cobra.Command{
	Use:          "passtool",
	SilenceUsage: true,
	Short:        "Passtool to work with encrypted secrets",
}

var passtoolEncCmd = &cobra.Command{
	Use:          "encrypt",
	SilenceUsage: true,
	Short:        "encrypt stdin",
	RunE: func(_ *cobra.Command, _ []string) error {
		data, err := io.ReadAll(os.Stdin)
		if err != nil {
			return fmt.Errorf("can't read stdin: %w", err)
		}

		in := string(bytes.TrimSpace(data))
		if len(in) == 0 {
			return errors.New("no data in stdin")
		}

		out, err := passutil.SecretVal(in).ToEncrypted()
		if err != nil {
			return err
		}

		fmt.Println(out)
		return nil
	},
}

var passtoolDecCmd = &cobra.Command{
	Use:          "decrypt",
	SilenceUsage: true,
	Short:        "decrypt stdin",
	RunE: func(_ *cobra.Command, _ []string) error {
		data, err := io.ReadAll(os.Stdin)
		if err != nil {
			return fmt.Errorf("can't read stdin: %w", err)
		}

		in := string(bytes.TrimSpace(data))
		if len(in) == 0 {
			return errors.New("no data in stdin")
		}

		var val passutil.SecretVal
		if err := val.FromAny(in); err != nil {
			return err
		}

		fmt.Println(val.String())
		return nil
	},
}

func init() {
	passtoolCmd.AddCommand(
		passtoolEncCmd,
		passtoolDecCmd,
	)
}
