package commands

import (
	"fmt"
	"strconv"
	"time"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/buildinfo"
	"a.yandex-team.ru/security/skotty/skotty/internal/version"
)

var versionArgs struct {
	Short bool
}

var versionCmd = &cobra.Command{
	Use:   "version",
	Short: "Print Skotty service version",
	RunE: func(cmd *cobra.Command, args []string) error {
		if versionArgs.Short {
			fmt.Println(version.Full())
			return nil
		}

		fmt.Println("Version:", version.Full())
		if t, err := strconv.ParseInt(buildinfo.Info.BuildTimestamp, 10, 64); err == nil {
			fmt.Println("Build at:", time.Unix(t, 0).String())
		}
		fmt.Println(buildinfo.Info.ProgramVersion)
		return nil
	},
}

func init() {
	versionCmd.PersistentFlags().BoolVar(&versionArgs.Short, "short", false, "print short version info")
}
