package confirm

import "fmt"

type Confirmator interface {
	Confirm(msg string) (bool, error)
}

func NewConfirmator(kind Kind, program string) (Confirmator, error) {
	switch kind {
	case KindSSHAskPass:
		return NewSSHAskPass(program), nil
	case KindPinentry:
		return NewPinentry(program), nil
	default:
		return nil, fmt.Errorf("unsupported confirmator kind: %s", kind)
	}
}
