package confirm

import (
	"sync"

	"a.yandex-team.ru/security/skotty/libs/askpass"
)

var _ Confirmator = (*SSHAskPass)(nil)

type SSHAskPass struct {
	c  *askpass.Client
	mu sync.Mutex
}

func NewSSHAskPass(program string) *SSHAskPass {
	var opts []askpass.ClientOption
	if program != "" {
		opts = append(opts, askpass.WithProgram(program))
	}

	return &SSHAskPass{
		c: askpass.NewClient(opts...),
	}
}

func (s *SSHAskPass) Confirm(msg string) (bool, error) {
	s.mu.Lock()
	defer s.mu.Unlock()

	return s.c.Confirm(msg)
}
