package main

import (
	"flag"
	"fmt"
	"os"
	"os/signal"
	"syscall"
	"time"
)

func main() {
	var (
		exitCode   int
		timeToExit time.Duration
	)
	flag.IntVar(&exitCode, "exit-code", 0, "exit code")
	flag.DurationVar(&timeToExit, "time-to-exit", 10*time.Second, "time to exit")
	flag.Parse()

	_, _ = fmt.Fprintln(os.Stderr, "crash-handler started")
	_, _ = fmt.Fprintf(os.Stderr, "under saver: %s\n", os.Getenv("CRASH_HANDLER_UNDER_CRASH_SAVER"))
	signals := make(chan os.Signal, 1)
	signal.Notify(signals)
	defer func() {
		signal.Stop(signals)
		close(signals)
	}()

loop:
	for {
		select {
		case s := <-signals:
			_, _ = fmt.Fprintf(os.Stderr, "signal received: %s\n", s)
			if s == syscall.SIGTERM {
				break loop
			}

		case <-time.After(timeToExit):
			break loop
		}
	}

	os.Exit(exitCode)
}
