package main

import (
	"encoding/json"
	"os"

	"a.yandex-team.ru/security/skotty/skotty/internal/crash"
)

func main() {
	tmpDir := os.TempDir()
	defer func() { _ = os.RemoveAll(tmpDir) }()

	s := crash.NewSaver(tmpDir,
		crash.WithName("self-crash"),
		crash.WithStdout(os.Stdout),
		crash.WithRestartHandler(func() bool {
			return false
		}),
	)
	if !s.IsParent() {
		_ = json.NewEncoder(os.Stdout).Encode(os.Args[1:])
		return
	}

	if _, err := s.StartChild(); err != nil {
		panic(err)
	}
}
