package crash

import (
	"io"
)

type Option func(s *Saver)

func WithStdout(stdout io.Writer) Option {
	return func(s *Saver) {
		s.stdout = stdout
	}
}

func WithStderr(stderr io.Writer) Option {
	return func(s *Saver) {
		s.stderr = stderr
	}
}

func WithName(name string) Option {
	return func(s *Saver) {
		s.name = name
	}
}

func WithExecutableFinder(fn func() (string, error)) Option {
	return func(s *Saver) {
		s.findExecutable = fn
	}
}

func WithArgs(args ...string) Option {
	return func(s *Saver) {
		s.args = args
	}
}

func WithRestartHandler(fn func() bool) Option {
	return func(s *Saver) {
		s.onRestart = fn
	}
}
