package diag

import (
	"bufio"
	"errors"
	"strings"

	"a.yandex-team.ru/security/skotty/skotty/internal/procutil"
)

func collectOS(out *Writer) error {
	return collectCommand(out, "uname", "-mrs")
}

func collectUSBDevices(out *Writer) error {
	return collectCommand(out, "lsusb")
}

func checkYubikeyVendorDevices(out *Writer) error {
	r, err := procutil.RunCommand("lsusb", "-d", "1050:")
	if err != nil {
		return err
	}

	scanner := bufio.NewScanner(strings.NewReader(r.Stdout))
	for scanner.Scan() {
		if strings.Contains(strings.ToLower(scanner.Text()), "yubikey") {
			return nil
		}
	}

	if err := scanner.Err(); err != nil {
		return err
	}

	return errors.New("yubikey was not found in the lsusb output")
}

func collectPCSCD(out *Writer) error {
	return collectCommand(out, "sh", "-c", "ps aux | grep pcscd | grep -v grep")
}
