package diag

import (
	"bufio"
	"errors"
	"fmt"
	"os"
	"strings"

	"a.yandex-team.ru/security/skotty/skotty/internal/procutil"
)

func collectOS(out *Writer) error {
	releaseFiles := []string{
		"/etc/os-release",
		"/etc/lsb-release",
	}

	for _, releaseFile := range releaseFiles {
		if _, err := os.Stat(releaseFile); err != nil {
			continue
		}

		data, err := os.ReadFile(releaseFile)
		if err != nil {
			return err
		}

		out.Write(data)
		return nil
	}

	return fmt.Errorf("can't find any of the release file: %s", strings.Join(releaseFiles, ","))
}

func collectUSBDevices(out *Writer) error {
	return collectCommand(out, "lsusb")
}

func checkYubikeyVendorDevices(out *Writer) error {
	r, err := procutil.RunCommand("lsusb", "-d", "1050:")
	if err != nil {
		return err
	}

	scanner := bufio.NewScanner(strings.NewReader(r.Stdout))
	for scanner.Scan() {
		if strings.Contains(strings.ToLower(scanner.Text()), "yubikey") {
			return nil
		}
	}

	if err := scanner.Err(); err != nil {
		return err
	}

	return errors.New("yubikey was not found in the lsusb output")
}

func collectPCSCD(out *Writer) error {
	return collectCommand(out, "systemctl", "status", "pcscd")
}
