package diag

import (
	"fmt"
	"net"
	"os"
	"time"

	"github.com/Microsoft/go-winio"
	"golang.org/x/sys/windows/registry"
)

func collectOS(out *Writer) error {
	k, err := registry.OpenKey(registry.LOCAL_MACHINE, `SOFTWARE\Microsoft\Windows NT\CurrentVersion`, registry.QUERY_VALUE)
	if err != nil {
		return fmt.Errorf("unable to open `SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion` registry key: %w", err)
	}
	defer func() { _ = k.Close() }()

	cv, _, err := k.GetStringValue("CurrentVersion")
	if err != nil {
		out.Writefln("unable to get CurrentVersion: %v", err)
	}
	out.Writefln("CurrentVersion: %s", cv)

	pn, _, err := k.GetStringValue("ProductName")
	if err != nil {
		out.Writefln("unable to get ProductName: %v", err)
	}
	out.Writefln("ProductName: %s", pn)

	maj, _, err := k.GetIntegerValue("CurrentMajorVersionNumber")
	if err != nil {
		out.Writefln("unable to get CurrentMajorVersionNumber: %v", err)
	}
	out.Writefln("CurrentMajorVersionNumber: %d", maj)

	min, _, err := k.GetIntegerValue("CurrentMinorVersionNumber")
	if err != nil {
		out.Writefln("unable to get CurrentMinorVersionNumber: %v", err)
	}
	out.Writefln("CurrentMinorVersionNumber: %d", min)

	cb, _, err := k.GetStringValue("CurrentBuild")
	if err != nil {
		out.Writefln("unable to get CurrentBuild: %v", err)
	}
	out.Writefln("CurrentBuild: %s", cb)

	return nil
}

func collectPCSCD(_ *Writer) error {
	return errNotSupported
}

func collectUSBDevices(_ *Writer) error {
	return errNotSupported
}

func dialSock(sock string) (net.Conn, error) {
	timeout := 3 * time.Second
	return winio.DialPipe(sock, &timeout)
}

func checkYubikeyVendorDevices(out *Writer) error {
	tmpfile, err := os.CreateTemp("", "skotty-usb-list-*.ps1")
	if err != nil {
		return fmt.Errorf("create script: %w", err)
	}
	defer func() { _ = os.Remove(tmpfile.Name()) }()

	if _, err = tmpfile.WriteString(`Get-PnpDevice -PresentOnly | Where-Object { $_.InstanceId -match '^USB\\VID_1050' }`); err != nil {
		return fmt.Errorf("write script: %w", err)
	}

	if err := tmpfile.Close(); err != nil {
		return fmt.Errorf("write script: %w", err)
	}

	return collectCommand(out, "PowerShell", "–NoLogo", "–NoProfile", "-ExecutionPolicy", "Bypass", "-File", tmpfile.Name())
}
