package diag

import "io"

func Collect(w io.Writer) {
	out := NewWriter(w)
	for _, c := range collectors() {
		out.Writefln("===== Start of %q =====", c.name)
		if err := c.fn(out); err != nil {
			out.Writefln("failed: %v", err)
		}
		out.Writefln("===== End of %q =====\n\n", c.name)
	}
}
