package diag

import (
	"fmt"
	"io"
)

type Writer struct {
	w io.Writer
}

func NewWriter(w io.Writer) *Writer {
	return &Writer{
		w: w,
	}
}

func (w *Writer) Write(b []byte) {
	_, _ = w.w.Write(b)
}

func (w *Writer) WriteString(s string) {
	w.Write([]byte(s))
}

func (w *Writer) Writeln(a ...interface{}) {
	_, _ = fmt.Fprintln(w.w, a...)
}

func (w *Writer) Writef(format string, a ...interface{}) {
	_, _ = fmt.Fprintf(w.w, format, a...)
}

func (w *Writer) Writefln(format string, a ...interface{}) {
	_, _ = fmt.Fprintf(w.w, format+"\n", a...)
}
