//go:build !windows
// +build !windows

package executil

import (
	"os"
	"path/filepath"
	"strings"
)

func SuggestExecutables(name string) ([]string, error) {
	if strings.Contains(name, "/") {
		var globName string
		if stat, err := os.Stat(name); err == nil && stat.IsDir() {
			globName = filepath.Join(name, "*")
		} else {
			globName = name + "*"
		}

		files, err := filepath.Glob(globName)
		if err != nil {
			return nil, err
		}

		out := make([]string, 0, len(files))
		for _, f := range files {
			d, err := os.Stat(f)
			if err != nil {
				continue
			}

			if m := d.Mode(); m.IsDir() || m&0111 != 0 {
				out = append(out, f)
			}
		}
		return out, nil
	}

	globName := name + "*"
	path := os.Getenv("PATH")
	var out []string
	for _, dir := range filepath.SplitList(path) {
		if dir == "" {
			// Unix shell semantics: path element "" means "."
			dir = "."
		}
		files, err := filepath.Glob(filepath.Join(dir, globName))
		if err != nil {
			continue
		}

		for _, f := range files {
			d, err := os.Stat(f)
			if err != nil {
				continue
			}

			if m := d.Mode(); !m.IsDir() && m&0111 != 0 {
				out = append(out, f)
			}
		}
	}

	return out, nil
}
