package keyring

import (
	"errors"
	"fmt"
)

type AuthError struct {
	err error
}

func NewAuthError(nested error) *AuthError {
	return &AuthError{err: nested}
}

func (e AuthError) Error() string {
	return fmt.Sprintf("keyrign auth fail: %v", e.err)
}

func (e AuthError) Unwrap() error {
	return e.err
}

func (e AuthError) Is(target error) bool {
	return errors.Is(e.err, target)
}
