package chaintypes

import "a.yandex-team.ru/security/skotty/skotty/internal/keyring"

type Service interface {
	Session() (Session, error)
	Close()
}

type Session interface {
	FetchKeyPair(keyring.KeyPurpose) (KeyPair, error)
	SaveKeyPair(keyring.KeyPurpose, KeyPair) error
	Close()
}

type KeyPair struct {
	PrivKey []byte
	PubKey  []byte
}
