package keyring

import (
	"crypto"
	"crypto/x509"

	"a.yandex-team.ru/security/skotty/libs/skotty"
	"a.yandex-team.ru/security/skotty/skotty/internal/pinstore"
)

type Keyring interface {
	Serial() (string, error)
	TokenType() skotty.TokenType
	Name() string
	HumanName() string
	IsTouchableKey(keyType KeyPurpose) bool
	SupportedKeyTypes() []KeyPurpose
	PinStoreOpts() []pinstore.Option
	Tx() (Tx, error)
	Close()
}

type Tx interface {
	Serial() (string, error)
	TokenType() skotty.TokenType
	Name() string
	HumanName() string
	SupportedKeyTypes() []KeyPurpose
	AttestationCertificate() (*x509.Certificate, error)
	Attest(keyType KeyPurpose) (*x509.Certificate, error)
	RenewCertificate(keyType KeyPurpose) (*x509.Certificate, error)
	GenCertificate(keyType KeyPurpose) (*x509.Certificate, error)
	SetCertificate(keyType KeyPurpose, crt *x509.Certificate) error
	Certificate(keyType KeyPurpose) (*x509.Certificate, error)
	Signer(keyType KeyPurpose) (crypto.Signer, error)
	Close()
}
