package memring

import (
	"fmt"
	"sync"

	"a.yandex-team.ru/security/skotty/skotty/internal/keyring"
)

type KeyPair struct {
	PrivKey []byte
	PubKey  []byte
}

type MemStore struct {
	keys map[keyring.KeyPurpose]KeyPair
	mu   sync.RWMutex
}

func NewMemStore() *MemStore {
	return &MemStore{
		keys: make(map[keyring.KeyPurpose]KeyPair, len(supportedKeyTypes)),
	}
}

func (m *MemStore) GetCert(keyType keyring.KeyPurpose) (KeyPair, error) {
	m.mu.RLock()
	defer m.mu.RUnlock()

	out, ok := m.keys[keyType]
	if !ok {
		return KeyPair{}, fmt.Errorf("key %q not found", keyType)
	}
	return out, nil
}

func (m *MemStore) SaveCert(keyType keyring.KeyPurpose, keyPair KeyPair) error {
	m.mu.Lock()
	defer m.mu.Unlock()

	m.keys[keyType] = keyPair
	return nil
}
