package pubstore

import (
	"fmt"
	"os"
	"path/filepath"

	"a.yandex-team.ru/security/skotty/skotty/internal/keyring"
)

var _ PubStore = (*FileStore)(nil)

type FileStore struct {
	pubsPath string
}

func NewFileStore(pubsPath string) PubStore {
	return &FileStore{
		pubsPath: pubsPath,
	}
}

func (p *FileStore) SaveKey(keyringName string, keyType keyring.KeyPurpose, key []byte) error {
	keyPath := p.keyPath(keyringName, keyType)
	if err := os.MkdirAll(filepath.Dir(keyPath), 0o700); err != nil {
		return fmt.Errorf("failed to create directory for pub keys: %w", err)
	}

	return os.WriteFile(keyPath, key, 0o600)
}

func (p *FileStore) ReadKey(keyringName string, keyType keyring.KeyPurpose) ([]byte, error) {
	return os.ReadFile(p.keyPath(keyringName, keyType))
}

func (p *FileStore) keyPath(keyringName string, keyType keyring.KeyPurpose) string {
	suff := "-cert"
	if keyType == keyring.KeyPurposeLegacy {
		suff = ""
	}

	return filepath.Join(p.pubsPath, fmt.Sprintf("ssh_%s_%s%s.pub", keyringName, keyType, suff))
}
