package pubstore

import (
	"fmt"

	"a.yandex-team.ru/security/skotty/skotty/internal/keyring"
)

var _ PubStore = (*MemStore)(nil)

type MemStore struct {
	keys map[string][]byte
}

func NewMemStore() PubStore {
	return &MemStore{
		keys: make(map[string][]byte),
	}
}

func (m *MemStore) SaveKey(keyringName string, keyType keyring.KeyPurpose, key []byte) error {
	keyPath := m.keyPath(keyringName, keyType)
	m.keys[keyPath] = key
	return nil
}

func (m *MemStore) ReadKey(keyringName string, keyType keyring.KeyPurpose) ([]byte, error) {
	keyPath := m.keyPath(keyringName, keyType)
	blob, ok := m.keys[keyPath]
	if !ok {
		return nil, fmt.Errorf("key %s was not found", keyPath)
	}

	return blob, nil
}

func (m *MemStore) keyPath(keyringName string, keyType keyring.KeyPurpose) string {
	return fmt.Sprintf("%s@%s", keyType, keyringName)
}
