package yubiring

import (
	"crypto"
	"sync"

	"a.yandex-team.ru/security/skotty/skotty/internal/keyring"
)

type pubCache struct {
	cache map[keyring.KeyPurpose]crypto.PublicKey
	mu    sync.RWMutex
}

func (p *pubCache) Get(keyType keyring.KeyPurpose) crypto.PublicKey {
	p.mu.RLock()
	defer p.mu.RUnlock()
	return p.cache[keyType]
}

func (p *pubCache) Set(keyType keyring.KeyPurpose, pub crypto.PublicKey) {
	p.mu.Lock()
	p.cache[keyType] = pub
	p.mu.Unlock()
}
