package yubiring

import (
	"crypto"
	"errors"
	"io"

	"a.yandex-team.ru/security/libs/go/pcsc"
	"a.yandex-team.ru/security/skotty/libs/pinentry"
	"a.yandex-team.ru/security/skotty/skotty/internal/keyring"
	"a.yandex-team.ru/security/skotty/skotty/internal/pinstore"
	"a.yandex-team.ru/security/skotty/skotty/internal/yubikey"
)

type Signer struct {
	crypto.Signer
	pinRequester func(validator pinstore.PassphraseValidator) error
}

func (s *Signer) Sign(rand io.Reader, digest []byte, opts crypto.SignerOpts) (signature []byte, err error) {
	signature, err = s.Signer.Sign(rand, digest, opts)
	if err != nil {
		var authErr *yubikey.AuthErr
		if errors.As(err, &authErr) {
			return nil, keyring.NewAuthError(authErr)
		}

		var susanErr *pinentry.AssuanError
		if errors.As(err, &susanErr) {
			return nil, keyring.NewAuthError(susanErr)
		}

		var apduErr *pcsc.APDUError
		if errors.As(err, &apduErr) && apduErr.Status() == 0x6982 {
			return nil, errors.New("smart card error 6982: security status not satisfied, probably you don't touch the Yubikey")
		}
	}
	return
}
