package passutil

import "fmt"

type PassChecker func(pass string) error

func IsAlphanumeric(kind string) PassChecker {
	return func(s string) error {
		for _, v := range s {
			if ('Z' < v || v < 'A') && ('z' < v || v < 'a') && ('9' < v || v < '0') {
				return fmt.Errorf("%s must be alpha numeric", kind)
			}
		}

		return nil
	}
}

func IsConsecutivelyRepeated(kind string) PassChecker {
	return func(s string) error {
		var prev rune
		for _, v := range s {
			if prev == 0 || prev-1 == v || prev+1 == v {
				prev = v
				continue
			}

			return nil
		}

		return fmt.Errorf("%s must not consist of consecutive characters", kind)
	}
}

func IsSame(kind string) PassChecker {
	return func(s string) error {
		var prev rune
		for _, v := range s {
			if prev > 0 && prev != v {
				return nil
			}
			prev = v
		}

		return fmt.Errorf("%s contains same charactes", kind)
	}
}

func CheckPassword(pass string, checks ...PassChecker) error {
	for _, c := range checks {
		if err := c(pass); err != nil {
			return err
		}
	}
	return nil
}
