package passutil

import (
	"crypto/rand"
	"fmt"
	"math/big"
)

const charsetNum = "0123456789"
const charsetAlphaNum = "abcdefghijklmnopqrstuvwxyz" +
	"ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"

// used for tests
var randInt = func(max int64) (int64, error) {
	m := big.NewInt(max)
	n, err := rand.Int(rand.Reader, m)
	if err != nil {
		return 0, err
	}

	return n.Int64(), nil
}

func PasswordWithCharset(length int, charset string) (string, error) {
	b := make([]byte, length)
	for i := range b {
		n, err := randInt(int64(len(charset)))
		if err != nil {
			return "", fmt.Errorf("rand fail: %w", err)
		}

		b[i] = charset[n]
	}

	return string(b), nil
}

func Password(length int) (string, error) {
	return PasswordWithCharset(length, charsetAlphaNum)
}

func PIN(length int) (string, error) {
	return PasswordWithCharset(length, charsetNum)
}
