package paths

import (
	"fmt"
	"os"
	"path/filepath"

	"github.com/mitchellh/go-homedir"
)

const skottyDir = ".skotty"

func ConfigRoot() (string, error) {
	return inHome(skottyDir)
}

func Config() (string, error) {
	return inHome(skottyDir, "config.yaml")
}

func Sockets() (string, error) {
	return inHome(skottyDir, "sock")
}

func SSHKeys() (string, error) {
	return inHome(skottyDir, "pubs")
}

func CtlSocket() (string, error) {
	return inHome(skottyDir, "ctl.sock")
}

func Filering() (string, error) {
	return inHome(skottyDir, "filering")
}

func AgentLog() (string, error) {
	return inHome(skottyDir, "logs", "agent.log")
}

func Assets() (string, error) {
	if _, ok := os.LookupEnv("UNDER_LAUNCHER"); ok {
		selfExe, err := os.Executable()
		if err != nil {
			return "", err
		}

		return filepath.Join(filepath.Dir(selfExe), "usr", "share"), nil
	}

	return "/usr/share/skotty", nil
}

func inHome(elem ...string) (string, error) {
	dir, err := homedir.Dir()
	if err != nil {
		return "", fmt.Errorf("can't determine user home dir: %w", err)
	}

	return filepath.Join(append([]string{dir}, elem...)...), nil
}
