package pinstore

import "errors"

type PermanentError struct {
	Err error
}

func (e *PermanentError) Error() string {
	return e.Err.Error()
}

func (e *PermanentError) Unwrap() error {
	return e.Err
}

func (e *PermanentError) Is(target error) bool {
	_, ok := target.(*PermanentError)
	return ok
}

func Permanent(err error) error {
	if err == nil {
		return nil
	}

	return &PermanentError{
		Err: err,
	}
}

func UnwrapPermanent(err error) error {
	var permanent *PermanentError
	if errors.As(err, &permanent) {
		return permanent.Err
	}

	return err
}

func IsPermanent(err error) bool {
	var permanent *PermanentError
	return errors.As(err, &permanent)
}
