package memcache

import (
	"sync"

	"a.yandex-team.ru/security/skotty/skotty/internal/pinstore"
)

type Provider struct {
	pinstore.Provider
	serial     string
	passphrase string
	mu         sync.Mutex
}

type getterFn func(validator pinstore.PassphraseValidator, opts ...pinstore.Option) (string, error)

func NewProvider(parent pinstore.Provider) (*Provider, error) {
	return &Provider{
		Provider: parent,
	}, nil
}

func (p *Provider) GetPIN(validator pinstore.PassphraseValidator, opts ...pinstore.Option) (string, error) {
	return p.getAndStore(p.Provider.GetPIN, validator, opts...)
}

func (p *Provider) GetPassphrase(validator pinstore.PassphraseValidator, opts ...pinstore.Option) (string, error) {
	return p.getAndStore(p.Provider.GetPassphrase, validator, opts...)
}

func (p *Provider) getAndStore(fn getterFn, validator pinstore.PassphraseValidator, opts ...pinstore.Option) (string, error) {
	serial := serialFromOpts(opts)
	if serial == "" {
		return fn(validator, opts...)
	}

	p.mu.Lock()
	defer p.mu.Unlock()
	if p.serial == serial {
		err := validator(p.passphrase)
		if err == nil {
			return p.passphrase, nil
		}

		if pinstore.IsPermanent(err) {
			return "", pinstore.UnwrapPermanent(err)
		}
	}

	passphrase, err := fn(validator, opts...)
	if err != nil {
		return "", err
	}

	p.serial = serial
	p.passphrase = passphrase
	return passphrase, nil
}

func serialFromOpts(opts []pinstore.Option) string {
	for _, opt := range opts {
		switch o := opt.(type) {
		case pinstore.OptionSerial:
			return o.Serial
		}
	}

	return ""
}
