package plain

import (
	"a.yandex-team.ru/security/skotty/skotty/internal/pinstore"
)

var _ pinstore.Provider = (*Provider)(nil)

type Provider struct {
	secret string
}

func NewProvider(source string) (*Provider, error) {
	return &Provider{
		secret: pinstore.KindPlain.TrimSource(source),
	}, nil
}

func (p *Provider) CanStore() bool {
	return true
}

func (p *Provider) Source() (string, error) {
	return p.secret, nil
}

func (p *Provider) Kind() pinstore.Kind {
	return pinstore.KindPlain
}

func (p *Provider) StorePIN(pin string, _ ...pinstore.Option) error {
	return p.StorePassphrase(pin)
}

func (p *Provider) GetPIN(validator pinstore.PassphraseValidator, _ ...pinstore.Option) (string, error) {
	return p.GetPassphrase(validator)
}

func (p *Provider) StorePassphrase(passphrase string, _ ...pinstore.Option) error {
	p.secret = passphrase
	return nil
}

func (p *Provider) GetPassphrase(validator pinstore.PassphraseValidator, _ ...pinstore.Option) (string, error) {
	if err := validator(p.secret); err != nil {
		return "", pinstore.UnwrapPermanent(err)
	}

	return p.secret, nil
}
