package pinstore

type Provider interface {
	Source() (string, error)
	CanStore() bool
	Kind() Kind
	StorePIN(pin string, otps ...Option) error
	GetPIN(validator PassphraseValidator, opts ...Option) (string, error)
	StorePassphrase(passphrase string, opts ...Option) error
	GetPassphrase(validator PassphraseValidator, opts ...Option) (string, error)
}

type PassphraseValidator func(passphrase string) error

type Option interface {
	isOption()
}

type OptionSerial struct {
	Option
	Serial string
}

func WithSerial(serial string) Option {
	return OptionSerial{
		Serial: serial,
	}
}

type OptionDescription struct {
	Option
	Description string
}

func WithDescription(desc string) Option {
	return OptionDescription{
		Description: desc,
	}
}

type OptionSync struct {
	Option
	Enabled bool
}

func WithSync(enabled bool) Option {
	return OptionSync{
		Enabled: enabled,
	}
}
