package secret

import (
	"strings"

	"a.yandex-team.ru/security/skotty/skotty/internal/passutil"
	"a.yandex-team.ru/security/skotty/skotty/internal/pinstore"
)

var _ pinstore.Provider = (*Provider)(nil)

type Provider struct {
	secret passutil.SecretVal
}

func NewProvider(source string) (*Provider, error) {
	var secret passutil.SecretVal
	if err := secret.FromAny(source); err != nil {
		return nil, err
	}

	return &Provider{
		secret: secret,
	}, nil
}

func (p *Provider) CanStore() bool {
	return true
}

func (p *Provider) Source() (string, error) {
	out, err := p.secret.ToEncrypted()
	if err != nil {
		return "", err
	}

	//TODO(buglloc): ugly, refactoring of passutil.SecretVal needed
	return strings.TrimPrefix(out, "secret:"), nil
}

func (p *Provider) Kind() pinstore.Kind {
	return pinstore.KindSecret
}

func (p *Provider) StorePIN(pin string, _ ...pinstore.Option) error {
	return p.StorePassphrase(pin)
}

func (p *Provider) GetPIN(validator pinstore.PassphraseValidator, _ ...pinstore.Option) (string, error) {
	return p.GetPassphrase(validator)
}

func (p *Provider) StorePassphrase(passphrase string, _ ...pinstore.Option) error {
	p.secret = passutil.SecretVal(passphrase)
	return nil
}

func (p *Provider) GetPassphrase(validator pinstore.PassphraseValidator, _ ...pinstore.Option) (string, error) {
	pass := string(p.secret)
	if err := validator(pass); err != nil {
		return "", pinstore.UnwrapPermanent(err)
	}

	return pass, nil
}
