package scenario

import (
	"crypto/x509"
	"errors"
	"time"

	"a.yandex-team.ru/security/skotty/skotty/internal/config"
	"a.yandex-team.ru/security/skotty/skotty/internal/keyring"
)

var ErrAborted = errors.New("aborted")

var supportedKeyrings = []keyring.Kind{
	keyring.KindYubikey,
	keyring.KindKeychain,
	keyring.KindFiles,
}

var supportedKeys = []keyring.KeyPurpose{
	keyring.KeyPurposeLegacy,
	keyring.KeyPurposeSudo,
	keyring.KeyPurposeInsecure,
	keyring.KeyPurposeSecure,
	keyring.KeyPurposeRenew,
}

var renewKeys = []keyring.KeyPurpose{
	keyring.KeyPurposeSudo,
	keyring.KeyPurposeInsecure,
	keyring.KeyPurposeSecure,
	keyring.KeyPurposeRenew,
}

var restoredKeys = []keyring.KeyPurpose{
	keyring.KeyPurposeLegacy,
}

type RenewInfo struct {
	RenewToken string
	EnrollInfo config.EnrollInfo
}

type IssuedEnrollment struct {
	RenewToken    string
	ExpiresAt     time.Time
	Certs         []SignedCert
	StaffUploaded bool
	StaffErr      string
	EnrollInfo    config.EnrollInfo
}

type IssuedRenew struct {
	RenewToken string
	ExpiresAt  time.Time
	Certs      []SignedCert
	EnrollInfo config.EnrollInfo
}

type SignedCert struct {
	KeyType keyring.KeyPurpose
	Cert    *x509.Certificate
	SSHCert []byte
}

type TokenCert struct {
	KeyType keyring.KeyPurpose
	Cert    *x509.Certificate
}

type IssueEnrollmentReq struct {
	EnrollID  string
	AuthToken string
	Certs     []TokenCert
}

type IssueRenewReq struct {
	EnrollID  string
	AuthToken string
	Certs     []TokenCert
}

type AuthorizedKey struct {
	Purpose string
	Blob    string
}
