package scenario

import (
	"io"

	"a.yandex-team.ru/security/skotty/skotty/internal/keyring/pubstore"
)

type Option interface {
	isOption()
}

type logOutOption struct {
	Option
	out io.Writer
}

func WithLogOut(out io.Writer) Option {
	return logOutOption{out: out}
}

type enrollUpstreamOption struct {
	Option
	upstream string
}

func WithEnrollUpstream(upstream string) Option {
	return enrollUpstreamOption{upstream: upstream}
}

type pubStoreOption struct {
	Option
	pubStore pubstore.PubStore
}

func WithPubStore(pubStore pubstore.PubStore) Option {
	return pubStoreOption{pubStore: pubStore}
}
