package scenario

import (
	"fmt"

	"a.yandex-team.ru/security/libs/go/iokit"
	"a.yandex-team.ru/security/skotty/skotty/internal/yubikey"
)

type Replug struct {
	*Scenario
}

func NewReplug(opts ...Option) *Replug {
	return &Replug{
		Scenario: NewScenario(opts...),
	}
}
func (s *Replug) ListUSBDevices(vendorID, productID int, next func(devices []iokit.Device) error) error {
	s.LogInfo("initialize USB devices")

	out, err := iokit.List(vendorID, productID)
	if err == nil && len(out) == 0 {
		if productID > 0 {
			return fmt.Errorf(
				"USB device with vendorID=0x%x productID=0x%x was not found",
				vendorID, productID,
			)
		}

		return fmt.Errorf(
			"USB device with vendorID=0x%x productID=any was not found",
			vendorID,
		)
	}

	return next(out)
}

func (s *Replug) ListPIVDevices(next func(cards []yubikey.Card) error) error {
	s.LogInfo("initialize PIV devices")

	cards, err := yubikey.Cards()
	if err != nil {
		return fmt.Errorf("can't list yubikeys: %w", err)
	}

	return next(cards)
}

func (s *Replug) PrintPIVCards(cards []yubikey.Card) error {
	if len(cards) == 0 {
		s.LogWarn("Yubikeys recognized as a smart card was not found")
		return nil
	}

	s.LogSuccess("Yubikeys recognized as a smart card:")
	for i, card := range cards {
		fmt.Printf("  %d. %s\n", i, card)
	}
	return nil
}

func (s *Replug) PrintUSBDevices(devices []iokit.Device) error {
	if len(devices) == 0 {
		s.LogWarn("Yubikeys recognized as a USB device was not found")
		return nil
	}

	s.LogSuccess("Yubikeys recognized as a USB device:")
	for i, device := range devices {
		fmt.Printf("  %d. %s\n", i, device)
	}
	return nil
}
