package scenario

import (
	"fmt"
	"os/exec"

	"a.yandex-team.ru/security/libs/go/iokit"
	"a.yandex-team.ru/security/skotty/libs/isroot"
)

func (s *Replug) ReplugSmartCard(d iokit.Device, next func() error) error {
	s.LogInfo("trying to kill ctkd")
	if err := s.callKillAll("ctkd"); err != nil {
		s.LogWarn("fail: %v", err)
	} else {
		s.LogSuccess("done")
	}

	s.LogInfo("try to kill ifdreader")
	if err := s.callKillAll("com.apple.ifdreader"); err != nil {
		s.LogWarn("fail: %v", err)
	} else {
		s.LogSuccess("done")
	}

	s.LogInfo("trying to replug %s", d)
	if err := d.Replug(); err != nil {
		return fmt.Errorf("unable to replug %s: %w", d, err)
	}

	return next()
}

func (s *Replug) callKillAll(prog string) error {
	var cmd *exec.Cmd
	if isroot.IsRoot() {
		cmd = exec.Command("killall", "-9", prog)
	} else {
		s.LogInfo("not enough permissions, calling sudo for rescue")
		cmd = exec.Command("sudo", "killall", "-9", prog)
	}

	s.LogInfo("invoke command: %s", cmd)
	return cmd.Run()
}
