//go:build !windows
// +build !windows

package scenario

import (
	"a.yandex-team.ru/security/skotty/skotty/internal/config"
	"a.yandex-team.ru/security/skotty/skotty/internal/keyring"
	"a.yandex-team.ru/security/skotty/skotty/internal/setup/asker"
	"a.yandex-team.ru/security/skotty/skotty/internal/socket"
)

var defaultSockets = []config.Socket{
	{
		Name: socket.NameDefault,
		Kind: socket.KindUnix,
		Keys: []keyring.KeyPurpose{
			keyring.KeyPurposeSecure,
			keyring.KeyPurposeInsecure,
			keyring.KeyPurposeSudo,
			keyring.KeyPurposeLegacy,
		},
	},
	{
		Name: socket.NameSudo,
		Kind: socket.KindUnix,
		Keys: []keyring.KeyPurpose{
			keyring.KeyPurposeSudo,
		},
	},
}

func selectSockets(next func([]config.Socket) error) error {
	notify, err := asker.ConfirmSocketNotifications()
	if err != nil {
		return err
	}

	out := make([]config.Socket, len(defaultSockets))
	for i, sock := range defaultSockets {
		sock.NotifyUsage = notify
		out[i] = sock
	}
	return next(out)
}
