package setuputil

import (
	"a.yandex-team.ru/security/skotty/libs/skotty"
	"a.yandex-team.ru/security/skotty/skotty/internal/keyring"
)

func KeyPurposeToCertType(purpose keyring.KeyPurpose) skotty.CertType {
	switch purpose {
	case keyring.KeyPurposeSecure:
		return skotty.CertTypeSecure
	case keyring.KeyPurposeInsecure:
		return skotty.CertTypeInsecure
	case keyring.KeyPurposeSudo:
		return skotty.CertTypeSudo
	case keyring.KeyPurposeLegacy:
		return skotty.CertTypeLegacy
	case keyring.KeyPurposeRenew:
		return skotty.CertTypeRenew
	default:
		return skotty.CertTypeNone
	}
}
