package socket

import "io"

type Creds struct {
	UID  int
	PID  int
	Name string
	Cmd  string
}

type Conn interface {
	io.ReadWriteCloser
	Peer() Creds
}

type connWrapper struct {
	io.ReadWriteCloser
	peer Creds
}

func (c *connWrapper) Peer() Creds {
	return c.peer
}

func dummyCreds() Creds {
	return Creds{
		UID:  -1,
		PID:  -1,
		Name: "n/a",
		Cmd:  "n/a",
	}
}
