package socket

import (
	"fmt"
	"math"

	"github.com/shirou/gopsutil/v3/process"
)

func procInfo(pid int) (string, string, error) {
	if pid <= 0 {
		// that's fine, just no peer pid
		return "n/a", "n/a", nil
	}

	if pid > math.MaxInt32 {
		return "n/a", "n/a", fmt.Errorf("pid is too big: %d", pid)
	}

	proc := process.Process{
		Pid: int32(pid),
	}
	name, err := proc.Name()
	if err != nil {
		return "n/a", "n/a", fmt.Errorf("unable to read proc %d name: %w", pid, err)
	}

	// exe is not implemented for FreeBSD in gopsutil, so we use cmdline
	// maybe it's even better :)
	cmdLine, err := proc.Cmdline()
	if err != nil {
		return name, "n/a", fmt.Errorf("unable to resolve proc %d cmdline: %w", pid, err)
	}

	return name, cmdLine, nil
}
