//go:build linux || darwin || freebsd
// +build linux darwin freebsd

package socket

import (
	"net"

	"a.yandex-team.ru/security/skotty/libs/netutil"
)

func unixCreds(c net.Conn) (Creds, error) {
	cred, err := netutil.UnixSocketCreds(c)
	if err != nil {
		return dummyCreds(), err
	}

	procName, procCmd, _ := procInfo(cred.PID)
	return Creds{
		UID:  cred.UID,
		PID:  cred.PID,
		Name: procName,
		Cmd:  procCmd,
	}, nil
}
