package socket

import (
	"context"
	"net"
)

var _ Socket = (*DummySocket)(nil)

type DummySocket struct {
	ctx       context.Context
	cancelCtx context.CancelFunc
}

func NewDummySocket() Socket {
	ctx, cancel := context.WithCancel(context.Background())
	return &DummySocket{
		ctx:       ctx,
		cancelCtx: cancel,
	}
}

func (s *DummySocket) Addr() string {
	return "n/a"
}

func (s *DummySocket) Listen() error {
	return nil
}

func (s *DummySocket) Accept(ctx context.Context) (Conn, error) {
	select {
	case <-s.ctx.Done():
		return nil, net.ErrClosed
	case <-ctx.Done():
		return nil, ctx.Err()
	}
}

func (s *DummySocket) Close() error {
	s.cancelCtx()
	return nil
}
