package socket

import (
	"context"
	"fmt"

	"a.yandex-team.ru/security/skotty/skotty/internal/socket/putty"
)

var _ Socket = (*PageantSocket)(nil)

type PageantSocket struct {
	win *putty.PageantWindow
}

func NewPageantWindow() (*PageantSocket, error) {
	win, err := putty.NewPageantWindow()
	if err != nil {
		return nil, fmt.Errorf("failed to create pagent window")
	}

	return &PageantSocket{
		win: win,
	}, nil
}

func (s *PageantSocket) Addr() string {
	return "n/a"
}

func (s *PageantSocket) Listen() error {
	return nil
}

func (s *PageantSocket) Accept(ctx context.Context) (Conn, error) {
	conn, err := s.win.Accept(ctx)
	if err != nil {
		return nil, err
	}

	return &connWrapper{
		ReadWriteCloser: conn,
		peer:            dummyCreds(),
	}, nil
}

func (s *PageantSocket) Close() error {
	s.win.Close()
	return nil
}
