//go:build !linux
// +build !linux

package supervisor

import (
	"context"
	"errors"
	"net"

	"google.golang.org/grpc/credentials"
)

var _ credentials.TransportCredentials = (*unixSocketCredentials)(nil)

type unixSocketCredentials struct {
	serverName string
}

func newUnixSocketCredentials(_, _ int) *unixSocketCredentials {
	return &unixSocketCredentials{
		serverName: "locahost",
	}
}

func (u *unixSocketCredentials) ClientHandshake(_ context.Context, _ string, _ net.Conn) (net.Conn, credentials.AuthInfo, error) {
	return nil, nil, errors.New("ClientHandshake is not supported by unixSocketCredentials")
}

func (u *unixSocketCredentials) ServerHandshake(c net.Conn) (net.Conn, credentials.AuthInfo, error) {
	return c, u, nil
}

func (u *unixSocketCredentials) Info() credentials.ProtocolInfo {
	return credentials.ProtocolInfo{
		SecurityProtocol: "unix-socket-peer-creds",
		ServerName:       u.serverName,
	}
}

func (u *unixSocketCredentials) Clone() credentials.TransportCredentials {
	return &unixSocketCredentials{
		serverName: u.serverName,
	}
}

func (u *unixSocketCredentials) OverrideServerName(serverName string) error {
	u.serverName = serverName
	return nil
}

func (u *unixSocketCredentials) AuthType() string {
	return "unix-socket-peer-creds"
}
