package supervisor

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/skotty/skotty/internal/keyring"
	"a.yandex-team.ru/security/skotty/skotty/internal/keyring/pubstore"
	"a.yandex-team.ru/security/skotty/skotty/internal/ui"
)

type Option interface {
	isOption()
}

type RestartHandler func() error
type restartHandlerOption struct {
	Option
	fn RestartHandler
}

func WithRestartHandler(fn RestartHandler) Option {
	return restartHandlerOption{
		fn: fn,
	}
}

type KeyReloadHandler func() error
type keyReloadHandlerOption struct {
	Option
	fn KeyReloadHandler
}

func WithKeyReloadHandler(fn KeyReloadHandler) Option {
	return keyReloadHandlerOption{
		fn: fn,
	}
}

type loggerOption struct {
	Option
	logger log.Logger
}

func WithLogger(l log.Logger) Option {
	return loggerOption{
		logger: l,
	}
}

type notifierOption struct {
	Option
	notify ui.Notifier
}

func WithNotifier(n ui.Notifier) Option {
	return notifierOption{
		notify: n,
	}
}

type certsCheckerOption struct {
	Option
	pubStore    pubstore.PubStore
	keyringName string
	keys        []keyring.KeyPurpose
}

func WithCertsChecker(pubStore pubstore.PubStore, keyringName string, keys ...keyring.KeyPurpose) Option {
	return certsCheckerOption{
		pubStore:    pubStore,
		keyringName: keyringName,
		keys:        keys,
	}
}
