package ui

import (
	"fmt"
	"unsafe"

	"golang.org/x/sys/windows"

	"a.yandex-team.ru/security/skotty/skotty/internal/ui/winapi"
)

type menuBuilder struct {
	handle windows.Handle
	pos    uint32
}

type menuItem struct {
	title     string
	disabled  bool
	separator bool
}

func (m *menuBuilder) addMenuItem(mi menuItem) (uint32, error) {
	if mi.separator {
		return m.addSeparator()
	}

	return m.addStringItem(mi.title, mi.disabled)
}

func (m *menuBuilder) addStringItem(title string, disabled bool) (uint32, error) {
	mi := winapi.MenuItemInfo{
		Mask:     winapi.MIIM_FTYPE | winapi.MIIM_STRING | winapi.MIIM_ID | winapi.MIIM_STATE,
		Type:     winapi.MFT_STRING,
		ID:       m.pos,
		TypeData: windows.StringToUTF16Ptr(title),
		Cch:      uint32(len(title)),
	}
	mi.Size = uint32(unsafe.Sizeof(mi))
	if disabled {
		mi.State = winapi.MFS_DISABLED
	}

	if err := winapi.InsertMenuItem(m.handle, m.pos, true, &mi); err != nil {
		return 0, fmt.Errorf("failed to create tray menu item[%d]: %w", m.pos, err)
	}

	pos := m.pos
	m.pos++
	return pos, nil
}

func (m *menuBuilder) addSeparator() (uint32, error) {
	mi := winapi.MenuItemInfo{
		Mask: winapi.MIIM_FTYPE | winapi.MIIM_ID | winapi.MIIM_STATE,
		Type: winapi.MFT_SEPARATOR,
		ID:   m.pos,
	}
	mi.Size = uint32(unsafe.Sizeof(mi))
	if err := winapi.InsertMenuItem(m.handle, m.pos, true, &mi); err != nil {
		return 0, fmt.Errorf("failed to create tray menu item[%d]: %w", m.pos, err)
	}

	pos := m.pos
	m.pos++
	return pos, nil
}
