package ui

import (
	"context"
	"sync"
)

type NotificationKind uint8

const (
	NotificationKindNone NotificationKind = iota
	NotificationKindAlert
	NotificationKindWarning
	NotificationKindUserInteraction
)

type osNotification interface {
	Close()
}

type Notification struct {
	n         osNotification
	cancelCtx context.CancelFunc
	mu        sync.Mutex
}

func (n *Notification) Close() {
	n.mu.Lock()
	defer n.mu.Unlock()

	if n.cancelCtx != nil {
		n.cancelCtx()
	}

	if n.n != nil {
		n.n.Close()
	}
}
